---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.4
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- Date Created: September 27, 2000 MSW
-- Date Updated: October 16, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 092700 Renamed file ddl_main.sql	-> ddl_main5.sql
-- MSW 092700 Renamed file ddl_tables.sql -> ddl_tabl5.sql
-- MSW 092700 Renamed file ddl_procs.sql  -> ddl_proc5.sql
-- MSW 092700 Renamed file ddl_data.sql	-> ddl_data5.sql
-- MSW 092700 Added file 			-> ddl_test5.sql, Contains "TEST" data
-- MSW 092700 Added file 			-> ddl_extr5.sql, Contains extra DDL that doesn't fit other categories
-- MSW 100500 Split ddl_proc5.sql into 5 files -> ddl_pkg_user5.sql, ddl_pkg_eval5.sql, ddl_pkg_reco5.sql, ddl_pkg_clus5.sql, ddl_pkg_sear5.sql
-- MSW 100500 Added alkindi_index TABLESPACE
-- MSW 100500 Added sq_USER_CLUSTER_ID SEQUENCE
-- MSW 100600 Added file 			-> ddl_pkg_calc.sql, Contains recalcs stats package
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
-- AHW 100900 Added DROP TABLESPACE DDL
-- AHW 100900 Increased TABLESPACE size
-- MSW 100900 Renamed file ddl_tabl5.sql		-> ddl_tabl6.sql
-- MSW 100900 Renamed file ddl_pkg_user5.sql	-> ddl_pkg_user6.sql
-- MSW 100900 Renamed file ddl_pkg_eval5.sql	-> ddl_pkg_eval6.sql
-- MSW 100900 Renamed file ddl_pkg_reco5.sql	-> ddl_pkg_reco6.sql
-- MSW 100900 Renamed file ddl_pkg_clus5.sql	-> ddl_pkg_clus6.sql
-- MSW 100900 Renamed file ddl_pkg_sear5.sql	-> ddl_pkg_sear6.sql
-- MSW 100900 Renamed file ddl_pkg_calc5.sql	-> ddl_pkg_stat6.sql
-- MSW 100900 Renamed file ddl_extr5.sql		-> ddl_extr6.sql
-- MSW 100900 Renamed file ddl_data5.sql		-> ddl_data6.sql
-- MSW 100900 Renamed file ddl_test5.sql		-> ddl_test6.sql
-- AHW 100900 Moved test data from ddl_test6.sql to ddl_data6.sql
---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CONNECTION
---------------------------------------------------------------------------------------------------------
CONN system/manager
DROP USER alkindi CASCADE;

DROP TABLESPACE alkindi
    INCLUDING CONTENTS 
        CASCADE CONSTRAINTS; 

DROP TABLESPACE alkindi_index
    INCLUDING CONTENTS 
        CASCADE CONSTRAINTS; 

CREATE TABLESPACE alkindi PERMANENT							-- Tablespaces should be larger (see size estimates ~ 600M)
	DATAFILE 'tabspace_alkindi_1.dat' SIZE 50M REUSE			-- 50M is satisfactory for testing purposes
	DEFAULT STORAGE (INITIAL	50K
				NEXT		100K 	
				MINEXTENTS 	1
				MAXEXTENTS 	100
				PCTINCREASE 0) 
	ONLINE; 

CREATE TABLESPACE alkindi_index PERMANENT
	DATAFILE 'tabspace_alkindi_Ind_1.dat' SIZE 20M REUSE
	DEFAULT STORAGE  (INITIAL	50K
				NEXT		200K
				MINEXTENTS	1
				MAXEXTENTS	75
				PCTINCREASE 0)
	ONLINE;


CREATE USER alkindi IDENTIFIED BY password;

GRANT CONNECT, RESOURCE TO alkindi;

ALTER USER alkindi DEFAULT TABLESPACE alkindi TEMPORARY TABLESPACE temp;

CONN alkindi/password;
---------------------------------------------------------------------------------------------------------
-- END CONNECTION
---------------------------------------------------------------------------------------------------------


---------------------------------------------------------------------------------------------------------
-- BEGIN SEQUENCE CREATION
---------------------------------------------------------------------------------------------------------
CREATE SEQUENCE sq_USER_ID 		INCREMENT BY 1 START WITH 1000000 	NOMAXVALUE NOCYCLE CACHE 100 ORDER;

CREATE SEQUENCE sq_PRODUCT_ID 	INCREMENT BY 1 START WITH 1000000 	NOMAXVALUE NOCYCLE CACHE 100 ORDER;

CREATE SEQUENCE sq_USER_CLUSTER_ID 	INCREMENT BY 1 START WITH 1000	NOMAXVALUE NOCYCLE CACHE 100 ORDER;
---------------------------------------------------------------------------------------------------------
-- END SEQUENCE CREATION
---------------------------------------------------------------------------------------------------------

--@D:\ddl_tabl.sql;
--@D:\ddl_pkg_user.sql;
--@D:\ddl_pkg_eval.sql;
--@D:\ddl_pkg_reco.sql;
--@D:\ddl_pkg_clus.sql;
--@D:\ddl_pkg_sear.sql;
--@D:\ddl_pkg_stat.sql
--@D:\ddl_data.sql;


@ddl_tabl.sql;
@ddl_pkg_user.sql;
@ddl_pkg_eval.sql;
@ddl_pkg_reco.sql;
@ddl_pkg_clus.sql;
@ddl_pkg_sear.sql;
@ddl_pkg_stat.sql;
@ddl_data.sql;

COMMIT;

